// gworld.c

#include "main.h"
#include "gworld.h"
#include "blitter.h"
#include "graphics.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

GWorldPtr blobWorld, maskWorld, charMaskWorld, blastWorld, blastMaskWorld, boardWorld[2], playerWorld[2], playerSpriteWorld[2];
GDHandle  oldGD[kMaxGLevel];
GWorldPtr oldGW[kMaxGLevel];
int gLevel = 0;

void GetBlobGraphics( void )
{
	Rect myRect;
	
	// Get board
	
	myRect.top = myRect.left = 0;
	myRect.right = kBlobHorizSize * kGridAcross;
	myRect.bottom = kBlobVertSize * (kGridDown-1);
	
	InitGWorld( &boardWorld[0], &myRect, 16 );
	DrawPictInGWorld( boardWorld[0], picBoard ); 
	
	InitGWorld( &boardWorld[1], &myRect, 16 );
	if( ResourceExists( 'PICT', picBoardRight ) )
	{
		DrawPictInGWorld( boardWorld[1], picBoardRight ); 
	}
	else
	{
		DrawPictInGWorld( boardWorld[1], picBoard ); 
	}
		
	// Get blob worlds

	myRect.top = myRect.left = 0;
	myRect.right = kBlobHorizSize * kBlobFrames;
	myRect.bottom = kBlobVertSize * (kLight+1);
	
	InitGWorld( &blobWorld, &myRect, 16 );
	DrawPictInGWorld( blobWorld, picBlob ); 
	
	InitGWorld( &maskWorld, &myRect, 1 );
	DrawPictInGWorld( maskWorld, picBlobMask ); 

	InitGWorld( &charMaskWorld, &myRect, 1 );
	DrawPictInGWorld( charMaskWorld, picCharMask ); 
	
	// Get blast worlds
	
	myRect.top = myRect.left = 0;
	myRect.right = kBlastWidth;
	myRect.bottom = kBlastHeight * kBlastFrames;
	
	InitGWorld( &blastWorld, &myRect, 16 );
	DrawPictInGWorld( blastWorld, picBlast ); 
	
	InitGWorld( &blastMaskWorld, &myRect, 16 );
	DrawPictInGWorld( blastMaskWorld, picBlastMask ); 
}

void MakePictRes( GWorldPtr world, Str255 defaultName, short resID )
{
#if 0
	PicHandle myPicture;
	StandardFileReply reply;
	short refNum;

	QuickFadeIn( nil );
		
	StandardPutFile( "\pSnapshot?", defaultName, &reply );

	if( reply.sfGood )
	{
		PrepareForGDrawing( world );
		myPicture = OpenPicture( &world->portRect );
		CopyBits( (BitMap*) &world->portPixMap, (BitMap*) &world->portPixMap,
					&world->portRect,	&world->portRect,
					srcCopy, nil );
		ClosePicture( );
		FinishGDrawing( world );
		
		FSpCreateResFile( &reply.sfFile, '8BIM', 'SCRN', reply.sfScript );
		
		refNum = FSpOpenResFile( &reply.sfFile, fsWrPerm );
		AddResource( (Handle)myPicture, 'PICT', resID, "\p" );
		WriteResource( (Handle)myPicture );
		ReleaseResource( (Handle)myPicture );
		CloseResFile( refNum );
	}
#endif

	world, defaultName, resID;
}

void DrawBoard( int player, Rect *myRect )
{
	GrafPtr thePort;
	Rect srcRect, offsetRect;

	srcRect = *myRect;
	if( srcRect.top < 24 ) srcRect.top = 24;
	 
	offsetRect = srcRect;
	OffsetRect( &offsetRect, 0, -kBlobVertSize );
		
	GetPort( &thePort );
	CopyBits( GetPortBitMapForCopyBits(boardWorld[player]), GetPortBitMapForCopyBits(thePort),
			   &offsetRect, &srcRect, 
			   srcCopy, nil );
}

void DrawBlob( int player, Rect *myRect, int blob, int state, int charred )
{
	GrafPtr thePort;

	DrawBoard( player, myRect );
	DrawSprite( myRect, blob, state );

	if( charred & 0x0F )
	{
		Rect blobRect, charRect, alphaRect;
		
		CalcBlobRect( (charred & 0x0F), kBombTop-1, &charRect );
		CalcBlobRect( (charred & 0x0F), kBombBottom-1, &alphaRect );
		CalcBlobRect( state, blob-1, &blobRect );

		GetPort( &thePort );
		BlitWeightedAlphaDualMask( GetPortPixMap(thePort), GetGWorldPixMap(blobWorld),
		                             GetGWorldPixMap(charMaskWorld), GetGWorldPixMap(blobWorld),
                                   myRect, &charRect, &blobRect, &alphaRect, myRect, (charred & 0xF0)>>3 );
	}
}

void DrawShadow( Rect *myRect, int blob, int state )
{
	int x;
	Point offset[4] = { {-2, 0}, {0, -2}, {2, 0}, {0, 2} };
	
	if( blob > kEmpty )
	{
		Rect blobRect, destRect;

		for( x=0; x<4; x++ )
		{
			destRect = *myRect;
			OffsetRect( &destRect, offset[x].h, offset[x].v );
			
			CalcBlobRect( state, blob-1, &blobRect );
			BlitColorMask( GetGWorldPixMap(maskWorld), &blobRect, &destRect, 0, 0, 0, 3 );
		}
	}
}

void DrawColor( Rect *myRect, int blob, int state, int r, int g, int b, int w )
{
	if( blob > kEmpty )
	{
		Rect blobRect;

		CalcBlobRect( state, blob-1, &blobRect );
		BlitColorMask( GetGWorldPixMap(charMaskWorld), &blobRect, myRect, r, g, b, w );
	}
}

void DrawAlpha( Rect *myRect, int blob, int mask, int state )
{
	GrafPtr thePort;

	if( blob > kEmpty )
	{
		Rect blobRect, alphaRect;

		CalcBlobRect( state, blob-1, &blobRect );
		CalcBlobRect( state, mask-1, &alphaRect );
		
		GetPort( &thePort );
		BlitAlphaMask( GetPortPixMap(thePort), GetGWorldPixMap(blobWorld), GetGWorldPixMap(blobWorld), 
		               myRect, &blobRect, &alphaRect, myRect );
	}
}

void DrawSprite( Rect *myRect, int blob, int state )
{
	if( blob > kEmpty )
	{
		Rect blobRect;

		CalcBlobRect( state, blob-1, &blobRect );
		BlitBlobMask( &blobRect, myRect );
	}
}

void InitPlayerWorlds( void )
{
	Rect myRect;
	int count;
	
	myRect.top = myRect.left = 0;
	myRect.right = kGridAcross * kBlobHorizSize;
	myRect.bottom = kGridDown * kBlobVertSize;
	
	for( count=0; count<=1; count++ )
	{
		InitGWorld( &playerWorld[count], &myRect, 16 );
		InitGWorld( &playerSpriteWorld[count], &myRect, 16 );
	}
}

void DrawPictInGWorld( GWorldPtr gWorld, int pictID )
{
	PicHandle myPicture;
	
	PrepareForGDrawing( gWorld );
		
	ForeColor( blackColor );
	BackColor( whiteColor );
	myPicture = GetPicture( pictID );
	DrawPicture( myPicture, &(**myPicture).picFrame ); 
	ReleaseResource( (Handle)myPicture );
	
	FinishGDrawing( gWorld );
}

void DrawPictInPort( CGrafPtr port, int pictID )
{
	PicHandle myPicture;
	
	SetPort( port );
	ForeColor( blackColor );
	BackColor( whiteColor );
	
	myPicture = GetPicture( pictID );
	DrawPicture( myPicture, &(**myPicture).picFrame ); 
	ReleaseResource( (Handle)myPicture );
}

void InitGWorld( GWorldPtr *world, const Rect *worldSize, int depth )
{
	OSErr err;
	
	err=NewGWorld(	world,			// GWorld to be created
					    depth,			// Color depth
					    worldSize,  	// GWorld size
					    nil, nil, 0L 
					 );
					 
	if( err == memFullErr )
	{
		Error( errNoMemory, "\p(InitGWorld)" );
	}
	else if( err != noErr )
	{
		Str255 errorCode;
		errorCode[0] = sprintf( (char*)&errorCode[1], "InitGWorld (%d)", err );
		Error( errUnknown, errorCode );
	}
	
	LockPixels( GetGWorldPixMap(*world) );
	
	PrepareForGDrawing( *world );
	EraseRect( worldSize );
	FinishGDrawing( *world );
}

void PrepareForGDrawing( GWorldPtr world )
{
	GetGWorld( &(oldGW[gLevel]), &(oldGD[gLevel]) );
	SetGWorld( world, nil );
	
	gLevel++;
	
	if( gLevel >= kMaxGLevel )
		Error( errUnknown, "\pgLevel >= kMaxGLevel" );
}

void FinishGDrawing( GWorldPtr world )
{
	world; // unused
	
	gLevel--;
	
	if( gLevel < 0 )
		Error( errUnknown, "\pgLevel < 0" );
	
	SetGWorld( oldGW[gLevel], oldGD[gLevel] );
}